; (*| 15:59 10/09/1995 *)
TITLE	DTBW
PAGE	60,78

LF	EQU	0AH
CR	EQU	0DH
;
DOSD_READ	EQU  2		; Disk sector read
DOSD_PARAMS	EQU  8		; Return disk drive parameters
;
DOSF_CONOUT	EQU  2		; Console output
DOSF_DRCIO	EQU  6		; Direct console I/O
DOSF_OUTSTR	EQU  9		; Output string
DOSF_STCON	EQU 11		; Status of console
DOSF_GFATA128	EQU 28		; Get file allocation table addr
;
DOSI_DISK	EQU 13H 	; Disk functions
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_ADREAD	EQU 25H		; Absolute disk read
;
DATA0	SEGMENT AT 0
	ORG	078H
DISKPTR LABEL	DWORD
DATA0	ENDS
;
;
PGROUP	SEGMENT
ASSUME	CS:PGROUP,DS:PGROUP,ES:PGROUP	;
	ORG	05CH
FCB1	DB	?
	ORG	06CH
FCB2	DB	?
	ORG	080H
CMDSTR	DB	?

	ORG	100H
START:	nop
	CLD
	MOV	DX,OFFSET TITMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	nop
	CALL	GETPHYS			; get current dos parameter
	MOV	BL,2
	MOV	BYTE PTR SECMAX,9
	MOV	AL,BYTE PTR FCB2+1
	CMP	AL,'0'
	JBE	NO_SIZE_CMD
	MOV	BYTE PTR SIZESET,0FFH	;Set flag for manual params
	AND	AL,0FH
	MOV	BL,AL
	CMP	AL,1
	JNZ	NOT256
	MOV	BYTE PTR SECMAX,16
	JMP	SHORT DONE_SIZE_CMD

NOT256:
	CMP	AL,3
	JNZ	NOT1024
	MOV	BYTE PTR SECMAX,5
	JMP	SHORT DONE_SIZE_CMD
NO_SIZE_CMD:
NOT1024:
DONE_SIZE_CMD:
	CALL	SETPHYS
	NOP
	NOP
	MOV	DH,0			;Head 0   (0-1)
	MOV	CL,1			;Sector 1 (1-9)
	MOV	CH,0			;Track 1  (0-39)
	MOV	SI,OFFSET FCB1
	LODSB
	CMP	AL,0
	JZ	NO_DRV_NUM
	DEC	AL
	MOV	BYTE PTR DRVNUM,AL
NO_DRV_NUM:
	LODSB
	CMP	AL,'?'
	JNZ	NOT_HELP
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	CALL	OLDPHYS
	INT	DOSI_FUNC
	INT	DOSI_TERM

NOT_HELP:
	CMP	AL,'0'
	JBE	NO_TRK_CMD
	AND	AL,0FH
	MOV	CH,AL
J_DONE_SET_TRK:
	JMP	DONE_SET_TRK

NO_TRK_CMD:
	MOV	AL,BYTE PTR SIZESET
	OR	AL,AL
	JNZ	J_DONE_SET_TRK

	MOV	AH,DOSF_GFATA128
	MOV	DL,BYTE PTR DRVNUM	;Drive (0-3)
	INC	DL			;Drive (1-4)
	PUSH	CX
	PUSH	DS
	INT	DOSI_FUNC
	MOV	AL,[BX] 		;Transfer FAT ID byte
	POP	DS
	POP	CX
	MOV	BYTE PTR SECMAX,8
	CMP	AL,0FEH
	JNZ	NOT_0FEH
	MOV	BYTE PTR HEADMAX,0
	JMP	SHORT DONE_DSK_PARAMS

NOT_0FEH:
	CMP	AL,0FFH
	JZ	DONE_DSK_PARAMS
	CMP	AL,0F8H
	JNZ	NOT_HARD_DISK
	MOV	DL,BYTE PTR DRVNUM	;Drive (2-3)
	ADD	DL,07EH
	MOV	BYTE PTR DRVOFS, 07EH
	MOV	AH,DOSD_PARAMS
	INT	DOSI_DISK
	MOV	BYTE PTR HEADMAX, DH
	MOV	AL,CL
	AND	AL,03FH
	MOV	BYTE PTR SECCNT, AL
	MOV	BYTE PTR SECMAX, AL
	MOV	AL,CL
	AND	AL,0C0H 		;hard disk track number hi 2 bits
	SUB	AH,AH
	ROL	AX,1
	ROL	AX,1
	MOV	AL,CH
	MOV	WORD PTR TRKMAX, AX
	MOV	CX,1			;sector 1
	SUB	DX,DX			;starting at first head
	JMP	SHORT DONE_DSK_PARAMS

NOT_HARD_DISK:
	MOV	BYTE PTR SECMAX,9
	MOV	AL,BYTE PTR DRVNUM	;Drive (0-3)
	MOV	CX,1			;sector	1
	SUB	DX,DX			;starting at first head
	MOV	BX,OFFSET BUFFER
	INT	DOSI_ADREAD
	ADD	SP,2			;Ignore PUSHF done by DOSI_ADREAD
	JC	DONE_DSK_PARAMS
	MOV	AL,BYTE PTR BUFFER+018H
	MOV	BYTE PTR SECMAX,AL
	MOV	AL,BYTE PTR BUFFER+01AH
	DEC	AL
	MOV	BYTE PTR HEADMAX,AL
DONE_DSK_PARAMS:

DONE_SET_TRK:
	MOV	AL,BYTE PTR DRVOFS
	ADD	BYTE PTR DRVNUM,AL	;add offset if hard disk
	MOV	CL,1
	MOV	SI,OFFSET FCB2+2
	MOV	DI,OFFSET SECCNT
	CALL	SET_DATA
	MOV	DI,OFFSET SECMAX
	CALL	SET_DATA
	MOV	DI,OFFSET HEADMAX
	CALL	SET_DATA
READ_LOOP:
	CALL	READ_SEC
	CALL	SHOW_POS
	CALL	TEST_KEY
	JNZ	ABORT
	CALL	NEXT_SEC
	XOR	AX,AX			;ax:=0
	MOV	AL,CL
	AND	AL,0C0H 		;hard disk track number hi 2 bits
	ROL	AX,1
	ROL	AX,1
	MOV	AL,CH			;Track number low
	CMP	AX,WORD PTR TRKMAX
	JBE	READ_LOOP
	nop
	nop
	nop
	nop
ABORT:
	CALL	OLDPHYS
	nop
	nop
	INT	DOSI_TERM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SET_DATA	PROC NEAR
	LODSB
	CMP	AL,'0'
	JB	NO_DATA
	AND	AL,0FH
	STOSB
NO_DATA:
	RET
SET_DATA	ENDP

READ_SEC	PROC NEAR
	MOV	BL,4
RD_SEC_LP:
	PUSH	BX
	MOV	AH,DOSD_READ
	MOV	DL,BYTE PTR DRVNUM	;Drive A: (0-3)
	MOV	AL,BYTE PTR SECCNT	;No of sectors to read
	MOV	BX,OFFSET BUFFER
	INT	DOSI_DISK
	POP	BX
	JNB	RD_SEC_OK
	DEC	BL
	JNZ	RD_SEC_LP
RD_SEC_OK:
	RET
READ_SEC	ENDP

NEXT_SEC	PROC NEAR
	MOV	AL,BYTE PTR SECCNT
	ADD	CL,AL			;Sector
	MOV	AL,CL
	AND	AL,03FH
	CMP	AL,BYTE PTR SECMAX
	JBE	NEXT_OK
	AND	CL,0C0H
	OR	CL,1
	INC	DH			;Head
	CMP	DH,BYTE PTR HEADMAX
	JBE	NEXT_OK
	MOV	DH,0		    
	INC	CH			;Track
	CMP	CH,0
	JNZ	NEXT_OK
	ADD	CL,040H
NEXT_OK:
	RET
NEXT_SEC	ENDP

;BIN BYTE IN AL, PTR TO RESULT WORD IN DI
        
BIN_TO_ASC	PROC NEAR
	PUSH	CX
	MOV	AH,0
	MOV	CL,10
	DIV	CL
	ADD	AL,'0'
	ADD	AH,'0'
	STOSW
	POP	CX
	RET
BIN_TO_ASC	ENDP

BIN_TO_3ASC	PROC NEAR
	PUSH	CX
	MOV	CL,100
	DIV	CL
	ADD	AL,'0'
	STOSB
	MOV	AL,AH
	CALL	BIN_TO_ASC
	POP	CX
	RET
BIN_TO_3ASC	ENDP
        
        
SHOW_POS	PROC NEAR
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSHF
	MOV	AL,DH			;Head
	ADD	AL,'0'
	MOV	BYTE PTR HDNUM,AL
	MOV	AL,CL			;Sector
	AND	AL,03FH
	MOV	DI,OFFSET SECNUM
	CALL	BIN_TO_ASC
	XOR	AX,AX
	MOV	AL,CL
	AND	AL,0C0H
	ROL	AX,1
	ROL	AX,1
	MOV	AL,CH			;Track
	MOV	DI,OFFSET TRKNUM
	CALL	BIN_TO_3ASC
	MOV	DX,OFFSET TRKMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POPF
	PUSHF
	JNB	NO_CRLF
	MOV	DX,OFFSET CRLFMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
NO_CRLF:
	POPF
	POP	DI
	POP	DX
	POP	CX
	RET    
SHOW_POS	ENDP

TEST_KEY	PROC NEAR
	PUSH	DX
	MOV	AH,DOSF_DRCIO
	MOV	DL,0FFH
	INT	DOSI_FUNC
	POP	DX
	OR	AL,AL
	RET
TEST_KEY	ENDP

GETPHYS		PROC NEAR
	PUSH	AX
;	PUSH	BX
;	MOV	BL,1
	PUSH	SI
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX

	ASSUME	DS:DATA0

	LDS	SI,DISKPTR
	MOV	AL,[SI+3]
;	MOV	[SI+3],BL		; was NEWPHYS
	POP	DS
	POP	SI

	ASSUME	DS:PGROUP

	MOV	BYTE PTR OLDRPS,AL
	MOV	AX,2
	MOV	WORD PTR PHYSRECS,AX
	MOV	AX,32
	MOV	WORD PTR CPMDPT,AX
;	POP	BX
	POP	AX
	RET
GETPHYS		ENDP

SETPHYS		PROC NEAR
	PUSH	SI
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX

	ASSUME	DS:DATA0

	LDS	SI,DISKPTR
	MOV	AL,[SI+3]
	MOV	[SI+3],BL
	POP	DS
	POP	SI

	ASSUME	DS:PGROUP

	RET
SETPHYS		ENDP

OLDPHYS		PROC NEAR
	PUSH	AX
	PUSH	BX
	PUSH	SI
	MOV	BL,BYTE PTR OLDRPS
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX

	ASSUME	DS:DATA0

	LDS	SI,DISKPTR
	MOV	[SI+3],BL
	POP	DS
	POP	SI
	POP	BX
	POP	AX

	ASSUME	DS:PGROUP

	RET
OLDPHYS		ENDP

SIZESET DB	0	 
HEADMAX DB	1
SECMAX	DB	9
TRKMAX	DW	39
SECCNT	DB	1
DRVNUM	DB	0
DRVOFS	DB	0
OLDRPS	DB	(?)
PHYSRECS	DW	(?)
CPMDPT	DW	(?)
TRKMSG	DB	'T '
TRKNUM	DB	'000'
HDMSG	DB	' H '
HDNUM	DB	'0'
SECMSG	DB	' S '
SECNUM	DB	'01 ',CR,'$'
CRLFMSG DB	CR,LF,'$'
TITMSG	DB	'Disk Test Program by B Whitnall. V1.4'
	DB	CR,LF,'Press any key to abort'
	DB	CR,LF,'$'
HLPMSG	DB	'Usage : DTBW [Drive:][First Track] [C][M][S][H]',CR,LF
	DB	'        All parameters to be single digit integers',CR,LF
	DB	'    C : Sector size code (1..3)',CR,LF
	DB	'          1=256, 2=512 (IBM), 3=1024',CR,LF
	DB	'    M : Sector read at one go (1..Max Sector)',CR,LF
	DB	'    S : Max Sector (8..9 for IBM)',CR,LF
	DB	'    H : Number of Heads (sides) (0..1)',CR,LF
	DB	' Defaults: First Track=0, C=2, M=1, S=9, H=1',CR,LF,'$'
;ABRTMSG DB	'Cannot test hard disk, program aborted',CR,LF,'$'

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - START

IF	SPAN MOD 256
	ORG	(THIS_SITE + 256) - (SPAN MOD 256)
ENDIF

BUFFER:

PGROUP	ENDS
END	START
